import com.xebialabs.restito.semantics.Call;
import com.xebialabs.restito.semantics.Predicate;
import com.xebialabs.restito.semantics.Function;
import com.xebialabs.restito.server.StubServer;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.server.Response;

import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Condition.custom;
import static com.xebialabs.restito.semantics.Condition.method;

import java.io.IOException;

public class CancelReasonsListMock extends AbstractMock {
    private static String template;
    private static String templateTwo;

    public CancelReasonsListMock() {

        template = loadTemplate("cancel-reasons-list.json");
        templateTwo = loadTemplate("cancel-reasons-list-two.json");
    }

    @Override
    public void run(StubServer server) {
        Predicate<Call> validUri = new Predicate<Call>() {
            @Override
            public boolean apply(final Call input) {

                return input.getUri().matches(".*/cancel-reasons-list");
            }
        };

        Function<Response, Response> response = new Function<Response, Response>() {
            @Override
            public Response apply(Response input) {
                String uri = input.getRequest().getRequestURI();
                String siteCodeRegex = ".*/site/(\\d+)/patient";
                String siteCode = matchingRegex(uri, siteCodeRegex);
                try {
                    String output = template;
                    if (siteCode.equals("688")) {
                        output = templateTwo;
                    }
                    input.getWriter().write(output);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return input;
            }
        };

        whenHttp(server).match(custom(validUri), method(Method.GET))
            .then(generateResponse(HttpStatus.OK_200, response));
    }
}
